/*  [REXX]  */
/* 
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 */

/*  @(#) somc/ctoi.cmd 2.5 1/19/94 16:43:28 [5/15/94 17:52:41]
 *  Convert a .csc files to .idl files.
 */
nonomatch = "";
force = 0;

parse arg argv;

parse value argv with flag rest;
if flag = "-f" then do;
    force = 1;
    argv = rest;
end;

scflags = value("scflags",,"os2environment");
sc	= value("sc",,"os2environment");
if sc = "" then sc = "sc";

if scflags <> "" then
    cmd = "@" || sc "-mtypecheck -mrmstar -mconvert" scflags "-sidl";
else
    cmd = "@" || sc "-mtypecheck -mrmstar -mconvert -sidl";

do while argv <> "";
    parse value argv with i argv;
    iroot = root(i);
    if stream(i, "c", "query exists") <> "" then
	if stream(iroot || ".idl", "c", "query exists") <> "" then
	    say iroot || ".idl already exists"
	else do;
	    say i":";
	    cmd i;
	    if rc <> 0 then do;
		say "error in converting" i;
		"@del" iroot || ".id2 >nul 2>&1";
		if force = 0 then exit(-1);
	    end;
	    else
		"@ren" iroot || ".id2" iroot || ".idl";
	end;
    else do;
	say i "not found";
	exit(-1);
    end;
end;

"@del SMIDENTS.UNK >nul 2>&1";
exit(0);

root: procedure;
    parse arg fn;
    i = length(fn);
    root = fn;
    do while i>0 & root = fn
        if substr(fn,i,1) = '.' then
            root = LEFT(fn,i-1);
        i = i - 1
    end 
    return root;
